package fp;

/**
 * Defines a set of objects of type H that can be folded over
 * using an appropriate IFoldAlgo lambda.
 */
public interface IFoldHost<H> {
  /**
   * This method will take the given IFoldAlgo lambda and fold it over
   * the set of H objects.  
   * It is not defined as to whether the folding is a left vs right folding.
   * @param algo The IFoldAlgo lambda to fold over the elements of the set
   * @param base The base case value of the folding.  Is the same type as the return value.
   * @param inp A vararg list of arbitrary input parameters to be given to the lambda.
   * @return The result of folding the IFoldAlgo over all the elements of the set.
   */
  public abstract <R, P> R fold(IFoldAlgo<H,R,P> algo, R base, P... inp);
}
